import "pe"

rule Win32_Virus_Greenp : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "GREENP"
        description         = "Yara rule that detects Greenp virus."

        tc_detection_type   = "Virus"
        tc_detection_name   = "Greenp"
        tc_detection_factor = 5

    strings:
        $greenp_body_1 = {
            68 ?? ?? ?? ?? 60 FC E8 4E 05 00 00 E8 31 04 00 00 0F 82 93 00 00 00 80 BD ?? ?? ?? ?? 01 75 63 FF 95 ?? ?? ?? ?? 6A 01
            50 FF 95 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 6A 00 6A 00 FF 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 EC 18 8B FC
            6A 00 6A 00 6A 00 57 FF 95 ?? ?? ?? ?? 85 C0 74 10 57 FF 95 ?? ?? ?? ?? 57 FF 95 ?? ?? ?? ?? EB DF 68 ?? ?? ?? ?? 6A 00
            FF 95 ?? ?? ?? ?? 83 C4 18 EB 27 8D 85 ?? ?? ?? ?? 50 FF 95 ?? ?? ?? ?? 85 C0 75 16 8D 85 ?? ?? ?? ?? 50 FF 95 ?? ?? ??
            ?? 85 C0 74 05 E8 81 00 00 00 61 58 FF E0 ?? E8 04 00 00 00 [4] 8B 3C 24 81 EC 00 01 00 00 8B F4 56 68 00 01 00 00 FF
            95 ?? ?? ?? ?? AC AA 81 C4 00 01 00 00 FF 95 ?? ?? ?? ?? 83 F8 03 75 2D 83 EC 10 8B F4 56 8D 46 04 50 8D 46 08 50 8D 46
            0C 50 4F 57 FF 95 ?? ?? ?? ?? 8B 46 04 2B D2 F7 66 08 F7 66 0C 83 C4 10 3D 00 00 40 06 C3 [27] 81 EC ?? ?? ?? ?? 8B F4
            68 ?? ?? ?? ?? 56 FF 95 ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 8A 17 88 14 06 40 47 80 FA 00 75 F4 68 ?? ?? ?? ?? 6A 00 FF 95 ??
            ?? ?? ?? 97 56 57 B9 ?? ?? ?? ?? 8D B5 ?? ?? ?? ?? E8 3A 02 00 00 5F B8 ?? ?? ?? ?? 99 68 ?? ?? ?? ?? 59 F7 F1 40 F7 E1
            8B 57 3C 03 D7 0F B7 5A 14 8D 5C 13 40 8B 72 28 03 72 34 89 B5 ?? ?? ?? ?? C7 42 10 80 67 D5 40 FF 73 10 01 43 10 8B 43
            10 05 ?? ?? ?? ?? 89 43 08 58 03 43 0C 89 42 28 52 B8 ?? ?? ?? ?? 99 68 ?? ?? ?? ?? 59 F7 F1 40 F7 E1 5A 01 43 10 01 42
            50 81 42 50 ?? ?? ?? ?? 57 C6 85 ?? ?? ?? ?? 01 81 C7 ?? ?? ?? ?? 8D B5 ?? ?? ?? ?? B9 ?? ?? ?? ?? FC F3 A4 C6 85 ?? ??
            ?? ?? 00 5F 5E 6A 00 6A 00 6A 02 6A 00 6A 00 68 00 00 00 C0 56 FF 95 ?? ?? ?? ?? 93 50 8B C4 6A 00 50 B8 ?? ?? ?? ?? 99
        }

        $greenp_body_2 = {
            68 ?? ?? ?? ?? 59 F7 F1 40 F7 E1 50 57 53 FF 95 ?? ?? ?? ?? 58 57 FF 95 ?? ?? ?? ?? 53 FF 95 ?? ?? ?? ?? 6A 00 56 FF 95
            ?? ?? ?? ?? 50 50 8B FC 8D 57 04 2B C0 52 57 50 68 3F 00 0F 00 50 50 50 8D 85 ?? ?? ?? ?? 50 68 02 00 00 80 FF 95 ?? ??
            ?? ?? 85 C0 75 1E 6A 0C 56 6A 01 6A 00 8D 85 ?? ?? ?? ?? 50 FF 37 FF 95 ?? ?? ?? ?? FF 37 FF 95 ?? ?? ?? ?? 81 C4 ?? ??
            ?? ?? C3
        }

    condition:
        uint16(0) == 0x5A4D and ($greenp_body_1 at pe.entry_point) and $greenp_body_2
}